<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST, GET, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header('Content-Type: application/json');

// CONFIG
$SITE_KEY = '6LdOCpAqAAAAAOLNB3Vwt_H7Nw4GGCAbdYm5Brsb';
$WEBSITE_URL = 'https://payment.ivacbd.com/';
$requestId = $_GET['requestId'] ?? null;
if (!$requestId) exit;

// Validate user
if (!valid_user($requestId)) exit;

// API Keys
$CAPSOLVER_KEY = "CAP-48FC14F5A8F5A154139C5C0315FA4264F39190A7330A4525BEA8CC56408D9113";
$DEFAULT_CAPMONSTER_KEY = "ebeddf60eb6162653392ed951bd5f70e";
$ANTICAPTCHA_KEY = "c89f0a76b03e227478d1ed043103504b";

// Proxy config (Bright Data)
$proxyLines = [
    "38.153.152.244,9594,ooeszkik,wwyngsxvac7m",
    "86.38.234.176,6630,ooeszkik,wwyngsxvac7m",
    "173.211.0.148,6641,ooeszkik,wwyngsxvac7m",
    "161.123.152.115,6360,ooeszkik,wwyngsxvac7m",
    "216.10.27.159,6837,ooeszkik,wwyngsxvac7m",
    "154.36.110.199,6853,ooeszkik,wwyngsxvac7m",
    "45.151.162.198,6600,ooeszkik,wwyngsxvac7m",
    "185.199.229.156,7492,ooeszkik,wwyngsxvac7m",
    "185.199.228.220,7492,ooeszkik,wwyngsxvac7m",
    "185.199.231.45,8382,ooeszkik,wwyngsxvac7m",
    "185.199.228.220,7300,fvnjtrdp,9ghteya0emsl",
    "43.153.237.55,2333,u2996f123566205ba-zone-custom-region-bd,u2996f123566205ba",
];

$selectedLine = $proxyLines[array_rand($proxyLines)];
list($proxyAddress, $proxyPort, $proxyLogin, $proxyPassword) = explode(",", $selectedLine);


// Dedicated CapMonster keys
function getCapmonsterKey($requestId) {
    $specialKeys = [
        'Suman1' => 'd190306bca92b0f03c20cd7dbc2eebc2',
        'Dulal1' => '9e2f603f328df7aaa7f6ec47ad0d2504',
        'Rubel1' => 'a77fe2d118c687ea0dfc69f779decfa8',
    ];
    return $specialKeys[$requestId] ?? null;
}

// Helper: POST JSON
function postJson($url, $data) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_POSTFIELDS, is_array($data) ? json_encode($data) : $data);
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

// CapSolver
function solveWithCapsolver($requestId) {
    global $CAPSOLVER_KEY, $SITE_KEY, $WEBSITE_URL;
    global $proxyAddress, $proxyPort, $proxyLogin, $proxyPassword;

    $payload = [
        "clientKey" => $CAPSOLVER_KEY,
        "task" => [
            "type" => "ReCaptchaV2Task",
            "websiteURL" => $WEBSITE_URL,
            "websiteKey" => $SITE_KEY,
            "proxyType" => "http",
            "proxyAddress" => $proxyAddress,
            "proxyPort" => $proxyPort,
            "proxyLogin" => $proxyLogin,
            "proxyPassword" => $proxyPassword,
            "userAgent" => "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/122.0.0.0 Safari/537.36"
        ]
    ];

    $response = postJson("https://api.capsolver.com/createTask", $payload);
    //file_put_contents("capmonster_poll_debug.json", json_encode($response, JSON_PRETTY_PRINT));
    if (!$response || $response['errorId'] !== 0) {
        return ["success" => false, "error" => $response['errorDescription'] ?? "Unknown error", "provider" => "capsolver"];
    }

    $taskId = $response['taskId'];
    sleep(3);

    for ($i = 0; $i < 15; $i++) {
        sleep(3);
        $poll = postJson("https://api.capsolver.com/getTaskResult", [
            "clientKey" => $CAPSOLVER_KEY,
            "taskId" => $taskId
        ]);
        //file_put_contents("capmonster_poll_debug.json", json_encode($poll, JSON_PRETTY_PRINT));
        if ($poll && $poll['errorId'] === 0 && $poll['status'] === 'ready') {
            return ["success" => true, "token" => $poll['solution']['gRecaptchaResponse'], "provider" => "CS"];
        }
    }

    return ["success" => false, "error" => "Timeout", "provider" => "CS"];
}

// CapMonster
function solveWithCapmonster($requestId, $capmonsterKey) {
    global $SITE_KEY, $WEBSITE_URL;
    global $proxyAddress, $proxyPort, $proxyLogin, $proxyPassword;

    $payload = [
        "clientKey" => $capmonsterKey,
        "task" => [
            "type" => "RecaptchaV2Task",
            "websiteURL" => $WEBSITE_URL,
            "websiteKey" => $SITE_KEY,
            "proxyType" => "http",
            "proxyAddress" => $proxyAddress,
            "proxyPort" => $proxyPort,
            "proxyLogin" => $proxyLogin,
            "proxyPassword" => $proxyPassword,
            "userAgent" => "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/122.0.0.0 Safari/537.36"
        ]
    ];

    $response = postJson("https://api.capmonster.cloud/createTask", $payload);
    if (!$response || $response['errorId'] !== 0) {
        return ["success" => false, "error" => $response['errorDescription'] ?? "Unknown error", "provider" => "capmonster"];
    }

    $taskId = $response['taskId'];
    sleep(3);

    for ($i = 0; $i < 15; $i++) {
        sleep(3);
        $poll = postJson("https://api.capmonster.cloud/getTaskResult", [
            "clientKey" => $capmonsterKey,
            "taskId" => $taskId
        ]);
        //file_put_contents("capmonster_poll_debug.json", json_encode($poll, JSON_PRETTY_PRINT));
        if ($poll && $poll['errorId'] === 0 && $poll['status'] === 'ready') {
            return ["success" => true, "token" => $poll['solution']['gRecaptchaResponse'], "provider" => "CM"];
        }
    }

    return ["success" => false, "error" => "Timeout", "provider" => "CM"];
}

// AntiCaptcha
/*
function solveWithAnticaptcha($requestId) {
    global $ANTICAPTCHA_KEY, $SITE_KEY, $WEBSITE_URL;
    global $proxyAddress, $proxyPort, $proxyLogin, $proxyPassword;

    $create = postJson("https://api.anti-captcha.com/createTask", [
        "clientKey" => $ANTICAPTCHA_KEY,
        "task" => [
            "type" => "NoCaptchaTask",
            "websiteURL" => $WEBSITE_URL,
            "websiteKey" => $SITE_KEY,
            "proxyType" => "http",
            "proxyAddress" => $proxyAddress,
            "proxyPort" => $proxyPort,
            "proxyLogin" => $proxyLogin,
            "proxyPassword" => $proxyPassword,
            "userAgent" => "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/122.0.0.0 Safari/537.36"
        ]
    ]);

    if (!$create || $create['errorId'] !== 0) {
        return ["success" => false, "error" => $create['errorDescription'] ?? "Unknown error", "provider" => "anticaptcha"];
    }

    $taskId = $create['taskId'];
    file_put_contents("capmonster_poll_debug.json", json_encode($taskId, JSON_PRETTY_PRINT));
    sleep(3);

    for ($i = 0; $i < 15; $i++) {
        sleep(3);
        $result = postJson("https://api.anti-captcha.com/getTaskResult", [
            "clientKey" => $ANTICAPTCHA_KEY,
            "taskId" => $taskId
        ]);
        file_put_contents("capmonster_poll_debug.json", json_encode($result, JSON_PRETTY_PRINT));

        if ($result && $result['status'] === 'ready') {
            return ["success" => true, "token" => $result['solution']['gRecaptchaResponse'], "provider" => "AC"];
        }
    }

    return ["success" => false, "error" => "Timeout", "provider" => "AC"];
}*/

function solveWithAnticaptcha($requestId) {
    global $ANTICAPTCHA_KEY, $SITE_KEY, $WEBSITE_URL;
    $create = postJson("https://api.anti-captcha.com/createTask", [
        "clientKey" => $ANTICAPTCHA_KEY,
        "task" => [
            "type" => "NoCaptchaTaskProxyless",
            "websiteURL" => $WEBSITE_URL,
            "websiteKey" => $SITE_KEY
        ]
    ]);

    if (!$create || $create['errorId'] !== 0) {
        return ["success" => false, "error" => $create['errorDescription'] ?? "Unknown error", "provider" => "anticaptcha"];
    }

    $taskId = $create['taskId'];
    sleep(3);

    for ($i = 0; $i < 20; $i++) {
        sleep(3);
        $result = postJson("https://api.anti-captcha.com/getTaskResult", [
            "clientKey" => $ANTICAPTCHA_KEY,
            "taskId" => $taskId
        ]);
        if ($result && $result['status'] === 'ready') {
            return ["success" => true, "token" => $result['solution']['gRecaptchaResponse'], "provider" => "A"];
        }
    }
    return ["success" => false, "error" => "Timeout", "provider" => "anticaptcha"];
}

// Routing
$customKey = getCapmonsterKey($requestId);
if ($customKey) {
    $response = solveWithCapmonster($requestId, $customKey);
} else {
    $services = ['capsolver', 'capmonster', 'anticaptcha'];
    $chosen = $services[array_rand($services)];
    switch ($chosen) {
        case 'capsolver':
            $response = solveWithCapsolver($requestId);
            break;
        case 'capmonster':
            $response = solveWithCapmonster($requestId, $DEFAULT_CAPMONSTER_KEY);
            break;
        case 'anticaptcha':
            $response = solveWithAnticaptcha($requestId);
            break;
        default:
            $response = ["success" => false, "error" => "No solver selected"];
    }
}

echo json_encode($response);

// Validate user
// Validate user
function valid_user($username) {
    $USER_TOKENS_FILE = "/home/smartweb/ivac/user/user_tokens.json";
    
    // Load token data
    $userTokens = file_exists($USER_TOKENS_FILE) ? json_decode(file_get_contents($USER_TOKENS_FILE), true) : [];

    // Check if user exists
    if (!isset($userTokens[$username])) {
        echo json_encode(["success" => false, "error" => "User not found"]);
        exit;
    }

    $tokenData = $userTokens[$username];

    // Check if token data is valid
    if (!isset($tokenData["token"]) || !isset($tokenData["expires"])) {
        echo json_encode(["success" => false, "error" => "Invalid token structure"]);
        exit;
    }

    // Validate expiration
    if ($tokenData["expires"] > time()) {
        return true;
    } else {
        echo json_encode(["success" => false, "error" => "Token expired"]);
        exit;
    }
}

?>
