<?php
header("Access-Control-Allow-Origin: *"); 
header("Access-Control-Allow-Methods: POST, GET, OPTIONS"); 
header("Access-Control-Allow-Headers: Content-Type");
header('Content-Type: application/json');

// CONFIG
$SITE_KEY = '6LdOCpAqAAAAAOLNB3Vwt_H7Nw4GGCAbdYm5Brsb';
$WEBSITE_URL = 'https://payment.ivacbd.com/';
$requestId = $_GET['requestId'] ?? null;
if (!$requestId) exit;

// Validate user
if (!valid_user($requestId)) exit;

// API Keys
$CAPSOLVER_KEY = "CAP-48FC14F5A8F5A154139C5C0315FA4264F39190A7330A4525BEA8CC56408D9113";
$DEFAULT_CAPMONSTER_KEY = "ebeddf60eb6162653392ed951bd5f70e";
$ANTICAPTCHA_KEY = "c89f0a76b03e227478d1ed043103504b";

// Dedicated CapMonster keys
function getCapmonsterKey($requestId) {
    $specialKeys = [
        'Suman1' => 'd190306bca92b0f03c20cd7dbc2eebc2',
        'Dulal1' => '9e2f603f328df7aaa7f6ec47ad0d2504',
        'Rubel1' => 'a77fe2d118c687ea0dfc69f779decfa8',
    ];
    return $specialKeys[$requestId] ?? null;
}

// Helper: POST JSON
function postJson($url, $data) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_POSTFIELDS, is_array($data) ? json_encode($data) : $data);
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

// CAPTCHA Solvers
function solveWithCapsolver($requestId) {
    global $CAPSOLVER_KEY, $SITE_KEY, $WEBSITE_URL;
    $payload = [
        "clientKey" => $CAPSOLVER_KEY,
        "task" => [
            "type" => "ReCaptchaV2TaskProxyLess",
            "websiteURL" => $WEBSITE_URL,
            "websiteKey" => $SITE_KEY
        ]
    ];
    $response = postJson("https://api.capsolver.com/createTask", $payload);
    if (!$response || $response['errorId'] !== 0) {
        return ["success" => false, "error" => $response['errorDescription'] ?? "Unknown error", "provider" => "capsolver"];
    }

    $taskId = $response['taskId'];
    sleep(3);

    for ($i = 0; $i < 15; $i++) {
        sleep(3);
        $poll = postJson("https://api.capsolver.com/getTaskResult", [
            "clientKey" => $CAPSOLVER_KEY,
            "taskId" => $taskId
        ]);
        if ($poll && $poll['errorId'] === 0 && $poll['status'] === 'ready') {
            return ["success" => true, "token" => $poll['solution']['gRecaptchaResponse'], "provider" => "CS"];
        }
    }
    return ["success" => false, "error" => "Timeout", "provider" => "CS"];
}

function solveWithCapmonster($requestId, $capmonsterKey) {
    global $SITE_KEY, $WEBSITE_URL;
    $payload = [
        "clientKey" => $capmonsterKey,
        "task" => [
            "type" => "RecaptchaV2TaskProxyless",
            "websiteURL" => $WEBSITE_URL,
            "websiteKey" => $SITE_KEY
        ]
    ];
    $response = postJson("https://api.capmonster.cloud/createTask", $payload);
    if (!$response || $response['errorId'] !== 0) {
        return ["success" => false, "error" => $response['errorDescription'] ?? "Unknown error", "provider" => "capmonster"];
    }

    $taskId = $response['taskId'];
    sleep(3);

    for ($i = 0; $i < 15; $i++) {
        sleep(3);
        $poll = postJson("https://api.capmonster.cloud/getTaskResult", [
            "clientKey" => $capmonsterKey,
            "taskId" => $taskId
        ]);
        if ($poll && $poll['errorId'] === 0 && $poll['status'] === 'ready') {
            return ["success" => true, "token" => $poll['solution']['gRecaptchaResponse'], "provider" => "CM"];
        }
    }
    return ["success" => false, "error" => "Timeout", "provider" => "capmonster"];
}


function solveWithAnticaptcha($requestId) {
    global $ANTICAPTCHA_KEY, $SITE_KEY, $WEBSITE_URL;
    $create = postJson("https://api.anti-captcha.com/createTask", [
        "clientKey" => $ANTICAPTCHA_KEY,
        "task" => [
            "type" => "NoCaptchaTaskProxyless",
            "websiteURL" => $WEBSITE_URL,
            "websiteKey" => $SITE_KEY
        ]
    ]);

    if (!$create || $create['errorId'] !== 0) {
        return ["success" => false, "error" => $create['errorDescription'] ?? "Unknown error", "provider" => "anticaptcha"];
    }

    $taskId = $create['taskId'];
    sleep(3);

    for ($i = 0; $i < 20; $i++) {
        sleep(3);
        $result = postJson("https://api.anti-captcha.com/getTaskResult", [
            "clientKey" => $ANTICAPTCHA_KEY,
            "taskId" => $taskId
        ]);
        if ($result && $result['status'] === 'ready') {
            return ["success" => true, "token" => $result['solution']['gRecaptchaResponse'], "provider" => "A"];
        }
    }
    return ["success" => false, "error" => "Timeout", "provider" => "anticaptcha"];
}

// Routing logic
$customKey = getCapmonsterKey($requestId);
if ($customKey) {
    // Always use capmonster for these users
    $response = solveWithCapmonster($requestId, $customKey);
} else {
    // Random provider for others
    $services = ['capsolver', 'capmonster', 'anticaptcha'];
    $chosen = $services[array_rand($services)];

    switch ($chosen) {
        case 'capsolver':
            $response = solveWithCapsolver($requestId);
            break;
        case 'capmonster':
            $response = solveWithCapmonster($requestId, $DEFAULT_CAPMONSTER_KEY);
            break;
        case 'anticaptcha':
            $response = solveWithAnticaptcha($requestId);
            break;
        default:
            $response = ["success" => false, "error" => "No service selected"];
    }
}

echo json_encode($response);

// Validate user
function valid_user($username) {
    $USER_TOKENS_FILE = "/home/smartweb/ivac/user/user_tokens.json";
    
    // Load token data
    $userTokens = file_exists($USER_TOKENS_FILE) ? json_decode(file_get_contents($USER_TOKENS_FILE), true) : [];

    // Check if user exists
    if (!isset($userTokens[$username])) {
        echo json_encode(["success" => false, "error" => "User not found"]);
        exit;
    }

    $tokenData = $userTokens[$username];

    // Check if token data is valid
    if (!isset($tokenData["token"]) || !isset($tokenData["expires"])) {
        echo json_encode(["success" => false, "error" => "Invalid token structure"]);
        exit;
    }

    // Validate expiration
    if ($tokenData["expires"] > time()) {
        return true;
    } else {
        echo json_encode(["success" => false, "error" => "Token expired"]);
        exit;
    }
}

?>