<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

$CAPSOLVER_KEY = "CAP-48FC14F5A8F5A154139C5C0315FA4264F39190A7330A4525BEA8CC56408D9113";
$CAPMONSTER_KEY = "ebeddf60eb6162653392ed951bd5f70e";
$ANTICAPTCHA_KEY = "c89f0a76b03e227478d1ed043103504b";

$provider = $_GET['provider'] ?? null;
$taskId = $_GET['taskId'] ?? null;

if (!$provider || !$taskId) {
    echo json_encode(["success" => false, "error" => "Missing provider or taskId"]);
    exit;
}

function postJson($url, $data) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

$response = null;

switch ($provider) {
    case 'capsolver':
        $response = postJson("https://api.capsolver.com/getTaskResult", [
            "clientKey" => $CAPSOLVER_KEY,
            "taskId" => $taskId
        ]);
        break;

    case 'capmonster':
        $response = postJson("https://api.capmonster.cloud/getTaskResult", [
            "clientKey" => $CAPMONSTER_KEY,
            "taskId" => $taskId
        ]);
        break;

    case 'anticaptcha':
        $response = postJson("https://api.anti-captcha.com/getTaskResult", [
            "clientKey" => $ANTICAPTCHA_KEY,
            "taskId" => $taskId
        ]);
        break;
}

if ($response && $response['status'] === 'ready') {
    echo json_encode([
        "success" => true,
        "token" => $response['solution']['gRecaptchaResponse'],
        "provider" => $provider
    ]);
} else {
    echo json_encode(["success" => false, "status" => "pending"]);
}
