<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

// === Config ===
$SITE_KEY = '6LdOCpAqAAAAAOLNB3Vwt_H7Nw4GGCAbdYm5Brsb';
$WEBSITE_URL = 'https://payment.ivacbd.com/';
$CAPSOLVER_KEY = "CAP-48FC14F5A8F5A154139C5C0315FA4264F39190A7330A4525BEA8CC56408D9113";
$CAPMONSTER_KEY = "ebeddf60eb6162653392ed951bd5f70e";
$ANTICAPTCHA_KEY = "c89f0a76b03e227478d1ed043103504b";

$proxies = [
    "38.153.152.244,9594,ooeszkik,wwyngsxvac7m",
    "86.38.234.176,6630,ooeszkik,wwyngsxvac7m",
    "173.211.0.148,6641,ooeszkik,wwyngsxvac7m",
    "161.123.152.115,6360,ooeszkik,wwyngsxvac7m",
    "216.10.27.159,6837,ooeszkik,wwyngsxvac7m",
    "154.36.110.199,6853,ooeszkik,wwyngsxvac7m",
    "45.151.162.198,6600,ooeszkik,wwyngsxvac7m",
    "185.199.229.156,7492,ooeszkik,wwyngsxvac7m",
    "185.199.228.220,7492,ooeszkik,wwyngsxvac7m",
    "185.199.231.45,8382,ooeszkik,wwyngsxvac7m",
    "185.199.228.220,7300,fvnjtrdp,9ghteya0emsl",
    "43.153.237.55,2333,u2996f123566205ba-zone-custom-region-bd,u2996f123566205ba",
];

// === Validate input ===
$requestId = $_GET['requestId'] ?? null;
if (!$requestId) exit(json_encode(["success" => false, "error" => "Missing requestId"]));

// === Choose a provider ===
$providers = ['capsolver', 'capmonster', 'anticaptcha'];
$provider = $providers[array_rand($providers)];

// === Choose a proxy (used by capsolver and capmonster) ===
$proxyParts = explode(",", $proxies[array_rand($proxies)]);
list($proxyAddress, $proxyPort, $proxyLogin, $proxyPassword) = $proxyParts;

// === Reusable POST ===
function postJson($url, $data) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

$taskId = null;

switch ($provider) {
    case 'capsolver':
        $res = postJson("https://api.capsolver.com/createTask", [
            "clientKey" => $CAPSOLVER_KEY,
            "task" => [
                "type" => "ReCaptchaV2Task",
                "websiteURL" => $WEBSITE_URL,
                "websiteKey" => $SITE_KEY,
                "proxyType" => "http",
                "proxyAddress" => $proxyAddress,
                "proxyPort" => (int)$proxyPort,
                "proxyLogin" => $proxyLogin,
                "proxyPassword" => $proxyPassword,
                "userAgent" => "Mozilla/5.0 (Windows NT 10.0; Win64; x64)"
            ]
        ]);
        if (isset($res['taskId'])) $taskId = $res['taskId'];
        break;

    case 'capmonster':
        $res = postJson("https://api.capmonster.cloud/createTask", [
            "clientKey" => $CAPMONSTER_KEY,
            "task" => [
                "type" => "RecaptchaV2Task",
                "websiteURL" => $WEBSITE_URL,
                "websiteKey" => $SITE_KEY,
                "proxyType" => "http",
                "proxyAddress" => $proxyAddress,
                "proxyPort" => (int)$proxyPort,
                "proxyLogin" => $proxyLogin,
                "proxyPassword" => $proxyPassword,
                "userAgent" => "Mozilla/5.0 (Windows NT 10.0; Win64; x64)"
            ]
        ]);
        if (isset($res['taskId'])) $taskId = $res['taskId'];
        break;

    case 'anticaptcha':
        $res = postJson("https://api.anti-captcha.com/createTask", [
            "clientKey" => $ANTICAPTCHA_KEY,
            "task" => [
                "type" => "NoCaptchaTaskProxyless",
                "websiteURL" => $WEBSITE_URL,
                "websiteKey" => $SITE_KEY
            ]
        ]);
        if (isset($res['taskId'])) $taskId = $res['taskId'];
        break;
}

if (!$taskId) {
    echo json_encode(["success" => false, "error" => $res['errorDescription'] ?? "Task creation failed"]);
    exit;
}

echo json_encode([
    "success" => true,
    "provider" => $provider,
    "taskId" => $taskId,
    "pollUrl" => "?provider=$provider&taskId=$taskId"
]);
