<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

$requestId = $_GET['requestId'] ?? null;
$taskId = $_GET['taskId'] ?? null;
$provider = $_GET['provider'] ?? null;
if (!$requestId || !$taskId || !$provider || !valid_user($requestId)) exit;


$apiKeyMap = [
    'capsolver' => 'CAP-48FC14F5A8F5A154139C5C0315FA4264F39190A7330A4525BEA8CC56408D9113',
    'capmonster' => 'ebeddf60eb6162653392ed951bd5f70e',
    'anticaptcha' => 'c89f0a76b03e227478d1ed043103504b'
];

$apiUrlMap = [
    'capsolver' => 'https://api.capsolver.com/getTaskResult',
    'capmonster' => 'https://api.capmonster.cloud/getTaskResult',
    'anticaptcha' => 'https://api.anti-captcha.com/getTaskResult'
];

if (!isset($apiKeyMap[$provider])) {
    echo json_encode(["success" => false, "error" => "Invalid provider"]);
    exit;
}

$poll = postJson($apiUrlMap[$provider], [
    "clientKey" => $apiKeyMap[$provider],
    "taskId" => $taskId
]);

if ($poll && isset($poll['status']) && $poll['status'] === 'ready') {
    echo json_encode([
        "success" => true,
        "token" => $poll['solution']['gRecaptchaResponse'],
        "provider" => $provider
    ]);
} else {
    echo json_encode([
        "success" => false,
        "status" => $poll['status'] ?? 'unknown',
        "error" => $poll['errorDescription'] ?? null
    ]);
}

function postJson($url, $data) {
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
        CURLOPT_POSTFIELDS => json_encode($data)
    ]);
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

function valid_user($username) {
    $tokens = json_decode(@file_get_contents("/home/smartweb/ivac/user/user_tokens.json"), true);
    if (!isset($tokens[$username])) return false;
    $data = $tokens[$username];
    return isset($data["token"], $data["expires"]) && $data["expires"] > time();
}
?>
