<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

$SITE_KEY = '6LdOCpAqAAAAAOLNB3Vwt_H7Nw4GGCAbdYm5Brsb';
$WEBSITE_URL = 'https://payment.ivacbd.com/';
$requestId = $_GET['requestId'] ?? null;
if (!$requestId || !valid_user($requestId)) exit;

$CAPSOLVER_KEY = "CAP-48FC14F5A8F5A154139C5C0315FA4264F39190A7330A4525BEA8CC56408D9113";
$CAPMONSTER_KEY = "ebeddf60eb6162653392ed951bd5f70e";
$ANTICAPTCHA_KEY = "c89f0a76b03e227478d1ed043103504b";

// Choose provider
$services = ['capsolver', 'capmonster', 'anticaptcha'];
$chosen = $services[array_rand($services)];

// Common proxy config
$proxyLines = [
    "38.153.152.244,9594,ooeszkik,wwyngsxvac7m",
    "86.38.234.176,6630,ooeszkik,wwyngsxvac7m",
    "173.211.0.148,6641,ooeszkik,wwyngsxvac7m",
    "161.123.152.115,6360,ooeszkik,wwyngsxvac7m",
    "216.10.27.159,6837,ooeszkik,wwyngsxvac7m",
    "154.36.110.199,6853,ooeszkik,wwyngsxvac7m",
    "45.151.162.198,6600,ooeszkik,wwyngsxvac7m",
    "185.199.229.156,7492,ooeszkik,wwyngsxvac7m",
    "185.199.228.220,7492,ooeszkik,wwyngsxvac7m",
    "185.199.231.45,8382,ooeszkik,wwyngsxvac7m",
    "86.38.234.176,6630,fvnjtrdp,9ghteya0emsl",
    "173.211.0.148,6641,fvnjtrdp,9ghteya0emsl",
    "161.123.152.115,6360,fvnjtrdp,9ghteya0emsl",
    "216.10.27.159,6837,fvnjtrdp,9ghteya0emsl",
    "154.36.110.199,6853,fvnjtrdp,9ghteya0emsl",
    "45.151.162.198,6600,fvnjtrdp,9ghteya0emsl",
    "185.199.229.156,7492,fvnjtrdp,9ghteya0emsl",
    "185.199.228.220,7300,fvnjtrdp,9ghteya0emsl",
    "185.199.231.45,8382,fvnjtrdp,9ghteya0emsl",
];

list($proxyAddress, $proxyPort, $proxyLogin, $proxyPassword) = explode(",", $proxyLines[array_rand($proxyLines)]);

$payload = [
    "type" => "ReCaptchaV2Task",
    "websiteURL" => $WEBSITE_URL,
    "websiteKey" => $SITE_KEY,
    "proxyType" => "http",
    "proxyAddress" => $proxyAddress,
    "proxyPort" => (int)$proxyPort,
    "proxyLogin" => $proxyLogin,
    "proxyPassword" => $proxyPassword,
    "userAgent" => "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/122.0.0.0 Safari/537.36"
];

switch ($chosen) {
    case 'capsolver':
        $response = postJson("https://api.capsolver.com/createTask", [
            "clientKey" => $CAPSOLVER_KEY,
            "task" => $payload
        ]);
        break;
    case 'capmonster':
        $response = postJson("https://api.capmonster.cloud/createTask", [
            "clientKey" => $CAPMONSTER_KEY,
            "task" => $payload
        ]);
        break;
    case 'anticaptcha':
        $payload['type'] = "NoCaptchaTask";
        $response = postJson("https://api.anti-captcha.com/createTask", [
            "clientKey" => $ANTICAPTCHA_KEY,
            "task" => $payload
        ]);
        break;
}

if (isset($response['errorId']) && $response['errorId'] === 0) {
    echo json_encode([
        "success" => true,
        "taskId" => $response['taskId'],
        "provider" => $chosen
    ]);
} else {
    echo json_encode([
        "success" => false,
        "error" => $response['errorDescription'] ?? 'Unknown error'
    ]);
}

function postJson($url, $data) {
    $ch = curl_init($url);
    curl_setopt_array($ch, [
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_POST => true,
        CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
        CURLOPT_POSTFIELDS => json_encode($data)
    ]);
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

function valid_user($username) {
    $tokens = json_decode(@file_get_contents("/home/smartweb/ivac/user/user_tokens.json"), true);
    if (!isset($tokens[$username])) return false;
    $data = $tokens[$username];
    return isset($data["token"], $data["expires"]) && $data["expires"] > time();
}
?>
