<?php
header("Access-Control-Allow-Origin: *"); 
header("Access-Control-Allow-Methods: POST, GET, OPTIONS"); 
header("Access-Control-Allow-Headers: Content-Type");
header('Content-Type: application/json');

$API_KEY = "CAP-48FC14F5A8F5A154139C5C0315FA4264F39190A7330A4525BEA8CC56408D9113";
$WEBSITE_URL = 'https://payment.ivacbd.com/';
$SITE_KEY = '6LdOCpAqAAAAAOLNB3Vwt_H7Nw4GGCAbdYm5Brsb';
$TASKS_FILE = 'tasks.json'; // Temporary task file
$USER_TOKENS_FILE = "../token/user_tokens.json"; // User tokens file

$requestId = $_GET['requestId'] ?? null;

if (!$requestId) {
    //echo json_encode(["success" => false, "error" => "Missing request ID"]);
    exit;
}

//$time = time();
//$validate = "https://smartwebers.com/em/ivac/token/validate_token.php?username=" . urlencode($requestId) . "&t=". $time;
//$response = file_get_contents($validate);
//$data = json_decode($response, true);

//if (!$data["success"]) {
 //   echo json_encode(["success" => false, "error" => "Invalid or expired user token"]);
//    exit;
//}

// Function to send API requests
function sendRequest($url, $data) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

// Function to solve CAPTCHA
function solveCaptcha($requestId) {
    
    //sleep(10);
    //return ["success" => true, "token" => 'test'];
    //exit();
    
    global $API_KEY, $WEBSITE_URL, $SITE_KEY, $TASKS_FILE;

    // 1️⃣ Create Task
    $payload = json_encode([
        "clientKey" => $API_KEY,
        "task" => [
            "type" => "ReCaptchaV2TaskProxyLess",
            "websiteURL" => $WEBSITE_URL,
            "websiteKey" => $SITE_KEY
        ]
    ]);

    $response = sendRequest("https://api.capsolver.com/createTask", $payload);
    if (!$response || $response['errorId'] !== 0) {
        return ["success" => false, "error" => $response['errorDescription'] ?? "Unknown error"];
    }

    $taskId = $response['taskId'];

    // Store task
    $fp = fopen($TASKS_FILE, 'c+');
    if (flock($fp, LOCK_EX)) {
        // Read the existing contents
        $contents = stream_get_contents($fp);
        $tasks = $contents ? json_decode($contents, true) : [];
    
        // Make sure tasks is an array
        if (!is_array($tasks)) {
            $tasks = [];
        }
    
        // Update or insert the new task
        $tasks[$requestId] = $taskId;
    
        // Rewind and truncate file before writing
        ftruncate($fp, 0);
        rewind($fp);
        fwrite($fp, json_encode($tasks, JSON_PRETTY_PRINT));
        fflush($fp); // Flush output before unlocking
        flock($fp, LOCK_UN); // Unlock
    }
    fclose($fp);

    sleep(5);
    // 2️⃣ Poll for Result (Internal Polling)
    $maxAttempts = 10; // ~30 seconds max (3s per attempt)
    $attempts = 0;

    while ($attempts < $maxAttempts) {
        sleep(3);
        $pollPayload = json_encode([
            "clientKey" => $API_KEY,
            "taskId" => $taskId
        ]);

        $pollResponse = sendRequest("https://api.capsolver.com/getTaskResult", $pollPayload);

        if ($pollResponse && $pollResponse['errorId'] === 0 && $pollResponse['status'] === 'ready') {
            // 🔥 Fixed Syntax Error Here (Closing Bracket `]` added)
            return ["success" => true, "token" => $pollResponse['solution']['gRecaptchaResponse']];
        }

        $attempts++;
    }

    return ["success" => false, "error" => "CAPTCHA solve timeout"];
}

// Process the request (Only valid userToken can reach this point)
echo json_encode(solveCaptcha($requestId));
?>
