<?php
header("Access-Control-Allow-Origin: *"); 
header("Access-Control-Allow-Methods: POST, GET, OPTIONS"); 
header("Access-Control-Allow-Headers: Content-Type");
header('Content-Type: application/json');

// 🔐 CONFIG
$API_KEY = "c89f0a76b03e227478d1ed043103504b";
$WEBSITE_URL = 'https://payment.ivacbd.com/';
$SITE_KEY = '6LdOCpAqAAAAAOLNB3Vwt_H7Nw4GGCAbdYm5Brsb';

$requestId = $_GET['requestId'] ?? null;
if (!$requestId) exit;

// Helper: send POST request
function postRequest($url, $data) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
    $response = curl_exec($ch);
    curl_close($ch);
    return json_decode($response, true);
}

// Step 1️⃣: Create task
function createAntiCaptchaTask($apiKey, $websiteURL, $siteKey) {
    $payload = [
        "clientKey" => $apiKey,
        "task" => [
            "type" => "NoCaptchaTaskProxyless",
            "websiteURL" => $websiteURL,
            "websiteKey" => $siteKey
        ]
    ];

    return postRequest("https://api.anti-captcha.com/createTask", $payload);
}

// Step 2️⃣: Poll for result
function getTaskResult($apiKey, $taskId) {
    $payload = [
        "clientKey" => $apiKey,
        "taskId" => $taskId
    ];

    return postRequest("https://api.anti-captcha.com/getTaskResult", $payload);
}

// 👷 Main logic
function solveCaptcha($requestId) {
    global $API_KEY, $WEBSITE_URL, $SITE_KEY;

    $taskResponse = createAntiCaptchaTask($API_KEY, $WEBSITE_URL, $SITE_KEY);
    if (!$taskResponse || $taskResponse['errorId'] !== 0) {
        return ["success" => false, "error" => $taskResponse['errorDescription'] ?? "Unknown error"];
    }

    $taskId = $taskResponse['taskId'];

    // Wait & Poll
    sleep(10);
    $maxAttempts = 20;
    $delay = 5;

    for ($i = 0; $i < $maxAttempts; $i++) {
        $result = getTaskResult($API_KEY, $taskId);

        if ($result['errorId'] !== 0) {
            return ["success" => false, "error" => $result['errorDescription']];
        }

        if ($result['status'] === 'ready') {
            return ["success" => true, "token" => $result['solution']['gRecaptchaResponse']];
        }

        sleep($delay);
    }

    return ["success" => false, "error" => "Timeout while waiting for CAPTCHA solution"];
}

echo json_encode(solveCaptcha($requestId));
